--[[
Author: GtX | Andy
Date: 04.02.2018
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Usage: Increases the fill type limit only when required.

<modDesc descVersion="90">
    <extraSourceFiles>
        <sourceFile filename="scripts/FillTypeLimitIncrease.lua"/>
    </extraSourceFiles>
</modDesc>
]]

-- Only overwrite if another mod did not already load this script.
if FillTypeManager.FLI_NUM_BITS_CHECK == nil then
    FillTypeManager.FLI_NUM_BITS_CHECK = true

    -- Mods should only be adding fill types using the base game method so just one check / overwrite needed.
    FillTypeManager.loadModFillTypes = Utils.overwrittenFunction(FillTypeManager.loadModFillTypes, function(self, superFunc, ...)
        local oldSendNumBits = math.max(FillTypeManager.SEND_NUM_BITS or 8, 8)
        FillTypeManager.SEND_NUM_BITS = 12 -- Increase limit to 4095 while all fill types load. No need for anymore than this :-)

        superFunc(self, ...)

        local newSendNumBits = MathUtil.getNumRequiredBits(#self.fillTypes)
        FillTypeManager.SEND_NUM_BITS = math.max(newSendNumBits, oldSendNumBits) -- Set the new limit but no less than the default / original limit.

        if oldSendNumBits < newSendNumBits then
            Logging.devInfo("Fill type limit of '%d' was reached and increased to %d successfully.", 2 ^ oldSendNumBits - 1, 2 ^ newSendNumBits - 1)
        end
    end)
end
