--[[
    GetMissionDynamicInfoEvent

    Event to request an MissionDynamicInfo update from the server.

    @author: 		BayernGamers
    @date: 			12.06.2025
    @version:		1.0

    History:		v1.0 @12.06.2025 - initial implementation in FS 22
                    ------------------------------------------------------------------------------------------------------
    
    License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
                        Attribution:
                            You must give appropriate credit to the original author when using this work.
                        No Derivatives:
                            You may not alter, transform, or build upon this work in any way.
                        Usage: 
                            The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                        Additional Clause:
                            This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "GetMissionDynamicInfoEvent.lua")

GetMissionDynamicInfoEvent = {}
local GetMissionDynamicInfoEvent_mt = Class(GetMissionDynamicInfoEvent, Event)

EventIds.assignEventObjectId(GetMissionDynamicInfoEvent, "GetMissionDynamicInfoEvent", EventIds.eventIdNext)

function GetMissionDynamicInfoEvent.emptyNew()
	local self = Event.new(GetMissionDynamicInfoEvent_mt)

	return self
end

function GetMissionDynamicInfoEvent.new(password)
	local self = GetMissionDynamicInfoEvent.emptyNew()
	return self
end

function GetMissionDynamicInfoEvent:readStream(streamId, connection)
    log:printDevInfo("Reading stream", LoggingUtil.DEBUG_LEVELS.HIGH)
    assert(g_currentMission:getIsServer())

    if g_currentMission:getIsServer() and not connection:getIsServer() then
        log:printDevInfo("Broadcasting mission dynamic info", LoggingUtil.DEBUG_LEVELS.HIGH)
        g_currentMission:broadcastMissionDynamicInfo()
    end
end

function GetMissionDynamicInfoEvent:writeStream(streamId, connection)
    log:printDevInfo("Writing stream", LoggingUtil.DEBUG_LEVELS.HIGH)
end

function GetMissionDynamicInfoEvent:run(connection)
    log:printError("GetMissionDynamicInfoEvent is a client to server only event!")
end
